/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.cms.jcajce;

import amp_libs.org.bouncycastle.asn1.ASN1OctetString;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import amp_libs.org.bouncycastle.cms.CMSException;
import amp_libs.org.bouncycastle.cms.RecipientOperator;
import amp_libs.org.bouncycastle.cms.jcajce.JceKeyAgreeRecipient;
import amp_libs.org.bouncycastle.jcajce.io.MacOutputStream;
import amp_libs.org.bouncycastle.operator.GenericKey;
import amp_libs.org.bouncycastle.operator.MacCalculator;
import amp_libs.org.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;

public class JceKeyAgreeAuthenticatedRecipient
extends JceKeyAgreeRecipient {
    public JceKeyAgreeAuthenticatedRecipient(PrivateKey privateKey) {
        super(privateKey);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1OctetString aSN1OctetString, byte[] byArray) throws CMSException {
        final Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, subjectPublicKeyInfo, aSN1OctetString, byArray);
        final Mac mac = this.contentHelper.createContentMac(key, algorithmIdentifier2);
        return new RecipientOperator(new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(algorithmIdentifier2, key);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(mac);
            }

            @Override
            public byte[] getMac() {
                return mac.doFinal();
            }
        });
    }
}

