/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.world.biome;

import java.util.Optional;
import net.caffeinemc.mods.sodium.client.world.biome.BiomeColorMaps;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Biome.class})
public abstract class BiomeMixin {
    @Shadow
    @Final
    private Biome.ClimateSettings climateSettings;
    @Unique
    private boolean hasCustomGrassColor;
    @Unique
    private int customGrassColor;
    @Unique
    private boolean hasCustomFoliageColor;
    @Unique
    private int customFoliageColor;
    @Unique
    private int defaultColorIndex;
    @Unique
    private BiomeSpecialEffects cachedSpecialEffects;

    @Shadow
    public abstract BiomeSpecialEffects getModifiedSpecialEffects();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.setupColors();
    }

    @Unique
    private void setupColors() {
        this.cachedSpecialEffects = this.getModifiedSpecialEffects();
        Optional grassColor = this.cachedSpecialEffects.getGrassColorOverride();
        if (grassColor.isPresent()) {
            this.hasCustomGrassColor = true;
            this.customGrassColor = (Integer)grassColor.get();
        } else {
            this.hasCustomGrassColor = false;
        }
        Optional foliageColor = this.cachedSpecialEffects.getFoliageColorOverride();
        if (foliageColor.isPresent()) {
            this.hasCustomFoliageColor = true;
            this.customFoliageColor = (Integer)foliageColor.get();
        } else {
            this.hasCustomFoliageColor = false;
        }
        this.defaultColorIndex = this.getDefaultColorIndex();
    }

    @Overwrite
    public int getGrassColor(double x, double z) {
        if (this.getModifiedSpecialEffects() != this.cachedSpecialEffects) {
            this.setupColors();
        }
        int color = this.hasCustomGrassColor ? this.customGrassColor : BiomeColorMaps.getGrassColor(this.defaultColorIndex);
        BiomeSpecialEffects.GrassColorModifier modifier = this.cachedSpecialEffects.getGrassColorModifier();
        if (modifier != BiomeSpecialEffects.GrassColorModifier.NONE) {
            color = modifier.modifyColor(x, z, color);
        }
        return color;
    }

    @Overwrite
    public int getFoliageColor() {
        if (this.getModifiedSpecialEffects() != this.cachedSpecialEffects) {
            this.setupColors();
        }
        int color = this.hasCustomFoliageColor ? this.customFoliageColor : BiomeColorMaps.getFoliageColor(this.defaultColorIndex);
        return color;
    }

    @Unique
    private int getDefaultColorIndex() {
        double temperature = Mth.clamp((float)this.climateSettings.temperature(), (float)0.0f, (float)1.0f);
        double humidity = Mth.clamp((float)this.climateSettings.downfall(), (float)0.0f, (float)1.0f);
        return BiomeColorMaps.getIndex(temperature, humidity);
    }
}

